---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-Shards Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestShardsAction.java` 行86-604
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行5

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /_cat/shards と GET /_cat/shards/{index} | E-01 行92 | ○ |
| C-02 | AbstractListAction を継承 | E-01 行86 | ○ |
| C-03 | CatShardsAction.INSTANCE を使用 | E-01 行127 | ○ |
| C-04 | prirep は p/r/s の3値 | E-01 行394-402 | ○ |
| C-05 | 未割り当てシャードの情報表示 | E-01 行433-444 | ○ |
| C-06 | getOrNull ヘルパーメソッド | E-01 行360-368 | ○ |
| C-07 | リロケーティング時のノード名表示 | E-01 行411-421 | ○ |
| C-08 | allowSystemIndexAccessByDefault が true | E-01 行101-103 | ○ |
| C-09 | isRequestLimitCheckSupported が true | E-01 行112-114 | ○ |
| C-10 | cancel_after_time_interval パラメータ | E-01 行122 | ○ |
| C-11 | デフォルト表示カラム8個 | E-01 行151-160 | ○ |
| C-12 | seq_no カラム群 | E-01 行344-346 | ○ |
| C-13 | path.data/path.state カラム | E-01 行352-353 | ○ |
| C-14 | isActionPaginated は false | E-01 行601-603 | ○ |
| C-15 | 帳票一覧での定義内容 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの裏付けあり

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルト表示カラムがソースコードと一致しているか
- [ ] prirep の3値（p/r/s）の条件分岐が正確か
- [ ] 未割り当てシャード情報の表示条件が正確か
